'--------------------------------------------------------------
'                     (c) 1999-2002 MCS Electronics
'--------------------------------------------------------------
'  file: I2C.BAS
'  demo: I2CSEND and I2CRECEIVE
'--------------------------------------------------------------
$baud = 9600
$crystal = 8000000
Config Scl = Portc.0
Config Sda = Portc.1
Declare Sub Write_ioexp(byval Data As Byte )
Declare Sub Read_ioexp(byval Adres As Byte , Value As Byte)

Const Addressw = &H70                                       'slave write address of PCF8574A
Const Addressr = &H71                                       'slave read address of PCF8574A

Dim B As Byte , Adres As Byte , Value As Byte               'dim byte
Dim C As Integer , D As Byte , I As Byte

Print : Print "Test expanding 8 bit I/O with PCF8574A"
B = &B11111110
C = 5
D = 1
While B > 0
Do
Call Write_ioexp(b)
Waitms 100
Rotate B , Left , 1
Loop Until B = &B01111111
Do
Call Write_ioexp(b)
Waitms 100
Rotate B , Right , 1
Loop Until B = &B11111110
Wend
End

'sample of writing a byte to EEPROM AT2404
Sub Write_ioexp(byval Data As Byte)
    I2cstart                                                'start condition
    I2cwbyte Addressw                                       'slave address
    I2cwbyte Data                                           'value to write
    I2cstop                                                 'stop condition
    Waitms 10                                               'wait for 10 milliseconds
End Sub

Sub Read_ioexp(byval Adres As Byte , Value As Byte)
   I2cstart                                                 'generate start
   I2cwbyte Addressw                                        'slave adsress
   I2cwbyte Adres                                           'address of EEPROM
   I2cstart                                                 'repeated start
   I2cwbyte Addressr                                        'slave address (read)
   I2crbyte Value , Nack                                    'read byte
   I2cstop                                                  'generate stop
End Sub